# cart/server.js

- instana for ? Automatic Visualization and Performance Analysis:

line 1: const instana = require('@instana/collector');

- redis as database: 

line 10: const redis = require('redis');

line 376: var redisClient = redis.createClient({
    host: redisHost
});
redisClient.on('error', (e) => {
    logger.error('Redis ERROR', e);
});

redisClient.on('ready', (r) => {
    logger.info('Redis READY', r);
    redisConnected = true;
});

line 27: var redisConnected = false;

var redisHost = process.env.REDIS_HOST || 'redis'
var catalogueHost = process.env.CATALOGUE_HOST || 'catalogue'

- HTTP requests are used:

line 11: const request = require('request');
?line 12: const bodyParser = require('body-parser');

- offers web api via express:

line 13: const express = require('express');

line 41: app is called: const app = express();

line 388: app started: const port = process.env.CART_SERVER_PORT || '8080';
app.listen(port, () => {
    logger.info('Started on port', port);
});


- pino for logging (express) An express middleware to log with pino. Incidentally, it also works without express.

line 14: const pino = require('pino');
const expPino = require('express-pino-logger');

line 32: const logger = pino({
    level: 'info',
    prettyPrint: true,
    useLevelLabels: true
});
const expLogger = expPino({
    logger: logger
});

line 43: app.use(expLogger);

- prometheus for logging

line 17:
const promClient = require('prom-client');
const Registry = promClient.Registry;
const register = new Registry();

- API / LINKS

    - line 54: GET /health

    - line 63: GET /metrics

    - line 70: GET /cart/:id
        - line 71: -> redisClient.get

    - line 87: DELETE /cart/:id
        -line 88: -> redisClient.del

    - line 103: GET /rename/:from/:to
        - line 104: redisClient.get
        - line 113: saveCart / .then
            - line 365: calls into redisClient.setex (carts expire after 3600 s)
            - line 364: contains return new Promise => async connection 

    - line 125: GET /add/:id/:sku/:qty
        - line 139: called getProduct/ .then
            - line 348: calls PRODUCT: request('http://' + catalogueHost + ':8080/product/' + sku, (err, res, body) =>
            - line 347: contains return new Promise => async connection 
        - line 151: redisClient.get (checks if cart exists)
        - line 183: saveCart / .then
            - line 365: calls into redisClient.setex (carts expire after 3600 s)
            - line 364: contains return new Promise => async connection 

    - line 199: GET /update/:id/:sku/:qty
        - line 212: redisClient.get
        - line 242: saveCart / .then
            - line 365: calls into redisClient.setex (carts expire after 3600 s)
            - line 364: contains return new Promise => async connection 

    - line 255: POST /shipping/:id
        - line 262: redisClient.get
        - line 298: saveCart / .then
            - line 365: calls into redisClient.setex (carts expire after 3600 s)
            - line 364: contains return new Promise => async connection 












